<x-app-layout>
    <div class="bg-gray-100 min-h-screen py-12">
        <div class="max-w-3xl mx-auto px-4 sm:px-6 lg:px-8">
            <h1 class="text-3xl font-bold text-gray-900 mb-8 text-center">Booking Test Drive</h1>
            
            <div class="bg-white rounded-xl shadow-md p-8" x-data="testDriveForm()">
                <div class="mb-8">
                    <p class="text-gray-600 text-center">
                        Rasakan pengalaman berkendara sebelum membeli. Pilih jadwal dan lokasi test drive Anda.
                    </p>
                </div>

                <div class="space-y-6">
                    <!-- Pilihan Mobil -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Pilih Mobil</label>
                        <select x-model="carId" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            <option value="">-- Pilih Mobil --</option>
                            @foreach($cars as $car)
                                <option value="{{ $car->id }}">{{ $car->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- Jadwal -->
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Tanggal</label>
                            <input type="date" x-model="date" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Jam</label>
                            <input type="time" x-model="time" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                        </div>
                    </div>

                    <!-- Lokasi -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Lokasi Test Drive</label>
                        <select x-model="location" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            <option value="showroom">Di Showroom</option>
                            <option value="home">Di Rumah Saya (Home Service)</option>
                        </select>
                    </div>

                    <div x-show="location == 'home'">
                        <label class="block text-sm font-medium text-gray-700 mb-1">Alamat Lengkap</label>
                        <textarea x-model="address" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" rows="3"></textarea>
                    </div>

                    <!-- Kontak -->
                    <div>
                        <h2 class="text-xl font-bold text-gray-800 mb-4 border-b pb-2">Kontak</h2>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">Nama Lengkap</label>
                                <input type="text" x-model="contact.name" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500">
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-1">No. WhatsApp</label>
                                <input type="text" x-model="contact.phone" class="w-full rounded-md border-gray-300 shadow-sm focus:border-blue-500 focus:ring-blue-500" placeholder="0812...">
                            </div>
                        </div>
                    </div>

                    <button @click="submit()" class="w-full bg-blue-600 text-white font-bold py-3 rounded-lg hover:bg-blue-700 transition flex items-center justify-center gap-2">
                        <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.008-.57-.008-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/></svg>
                        Booking Sekarang via WhatsApp
                    </button>
                </div>
            </div>
        </div>
    </div>

    <script>
        function testDriveForm() {
            return {
                carId: '',
                date: '',
                time: '',
                location: 'showroom',
                address: '',
                contact: {
                    name: '',
                    phone: ''
                },
                submit() {
                    const message = `Halo, saya ingin Booking Test Drive.\n\nMobil: ${this.carId}\nTanggal: ${this.date} Jam ${this.time}\nLokasi: ${this.location}\nAlamat: ${this.address}\n\nNama: ${this.contact.name}`;
                    const url = `https://wa.me/6281234567890?text=${encodeURIComponent(message)}`;
                    window.open(url, '_blank');
                }
            }
        }
    </script>
</x-app-layout>
