<x-app-layout>
    <div class="bg-gray-100 min-h-screen py-12">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <!-- Breadcrumb -->
            <nav class="flex mb-8 text-gray-500 text-sm">
                <a href="{{ route('home') }}" class="hover:text-blue-600">Home</a>
                <span class="mx-2">/</span>
                <a href="{{ route('cars.index') }}" class="hover:text-blue-600">Katalog</a>
                <span class="mx-2">/</span>
                <span class="text-gray-900">{{ $car->name }}</span>
            </nav>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Main Content -->
                <div class="lg:col-span-2 space-y-8">
                    <!-- Gallery -->
                    <div class="bg-white rounded-xl shadow-sm overflow-hidden" x-data="{ activeImage: '{{ $car->images[0] ?? '' }}' }">
                        <div class="aspect-w-16 aspect-h-9 bg-gray-200">
                            <img :src="activeImage || 'https://via.placeholder.com/800x600'" class="w-full h-full object-cover">
                        </div>
                        <div class="p-4 overflow-x-auto whitespace-nowrap space-x-2">
                             @if(isset($car->images))
                                @foreach($car->images as $image)
                                <button @click="activeImage = '{{ $image }}'" class="inline-block w-20 h-20 rounded-lg overflow-hidden border-2 border-transparent hover:border-blue-500 focus:outline-none focus:border-blue-500">
                                    <img src="{{ $image }}" class="w-full h-full object-cover">
                                </button>
                                @endforeach
                            @endif
                        </div>
                    </div>

                    <!-- Description & Specs -->
                    <div class="bg-white rounded-xl shadow-sm p-6">
                        <h2 class="text-2xl font-bold mb-4">Deskripsi & Spesifikasi</h2>
                        <div class="prose max-w-none text-gray-600 mb-6">
                            {!! nl2br(e($car->description)) !!}
                        </div>
                        
                        @if($car->specs)
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            @foreach($car->specs as $key => $value)
                            <div class="flex justify-between py-2 border-b border-gray-100">
                                <span class="text-gray-500 capitalize">{{ str_replace('_', ' ', $key) }}</span>
                                <span class="font-medium text-gray-900">{{ $value }}</span>
                            </div>
                            @endforeach
                        </div>
                        @endif
                    </div>
                    
                    @if($car->video_url)
                    <!-- Video Embed -->
                    <div class="aspect-w-16 aspect-h-9 rounded-xl overflow-hidden shadow-sm">
                         <iframe src="{{ str_replace('watch?v=', 'embed/', $car->video_url) }}" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                    </div>
                    @endif
                </div>

                <!-- Sidebar Simulator -->
                <div class="lg:col-span-1">
                    <div class="sticky top-24 space-y-6">
                        <!-- Price Card -->
                        <div class="bg-white p-6 rounded-xl shadow-sm">
                            <h1 class="text-2xl font-bold text-gray-900 mb-2">{{ $car->name }}</h1>
                            <p class="text-blue-600 text-3xl font-bold mb-4">Rp {{ number_format($car->price, 0) }}</p>
                            
                            <a href="https://wa.me/6281234567890?text=Halo%20saya%20tertarik%20dengan%20{{ $car->name }}" target="_blank" class="block w-full bg-green-500 hover:bg-green-600 text-white font-bold py-3 rounded-lg text-center transition flex justify-center items-center gap-2">
                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 24 24"><path d="M17.472 14.382c-.297-.149-1.758-.867-2.03-.967-.273-.099-.471-.148-.67.15-.197.297-.767.966-.94 1.164-.173.199-.347.223-.644.075-.297-.15-1.255-.463-2.39-1.475-.883-.788-1.48-1.761-1.653-2.059-.173-.297-.018-.458.13-.606.134-.133.298-.347.446-.52.149-.174.198-.298.298-.497.099-.198.05-.371-.025-.52-.075-.149-.669-1.612-.916-2.207-.242-.579-.487-.5-.669-.51-.173-.008-.371-.008-.57-.008-.198 0-.52.074-.792.372-.272.297-1.04 1.016-1.04 2.479 0 1.462 1.065 2.875 1.213 3.074.149.198 2.096 3.2 5.077 4.487.709.306 1.262.489 1.694.625.712.227 1.36.195 1.871.118.571-.085 1.758-.719 2.006-1.413.248-.694.248-1.289.173-1.413-.074-.124-.272-.198-.57-.347m-5.421 7.403h-.004a9.87 9.87 0 01-5.031-1.378l-.361-.214-3.741.982.998-3.648-.235-.374a9.86 9.86 0 01-1.51-5.26c.001-5.45 4.436-9.884 9.888-9.884 2.64 0 5.122 1.03 6.988 2.898a9.825 9.825 0 012.893 6.994c-.003 5.45-4.437 9.884-9.885 9.884m8.413-18.297A11.815 11.815 0 0012.05 0C5.495 0 .16 5.335.157 11.892c0 2.096.547 4.142 1.588 5.945L.057 24l6.305-1.654a11.882 11.882 0 005.683 1.448h.005c6.554 0 11.89-5.335 11.893-11.893a11.821 11.821 0 00-3.48-8.413Z"/></svg>
                                Chat WhatsApp Sekarang
                            </a>
                        </div>

                        <!-- Credit Calculator -->
                        <div class="bg-white p-6 rounded-xl shadow-sm" x-data="creditCalculator()">
                            <h3 class="font-bold text-gray-900 mb-4 border-b pb-2">Simulasi Kredit</h3>
                            
                            <div class="space-y-4">
                                <div>
                                    <label class="text-sm text-gray-600 block mb-1">Harga Mobil</label>
                                    <input type="text" :value="formatRupiah(price)" class="w-full bg-gray-100 border-none rounded p-2 text-right" readonly>
                                </div>
                                
                                <div>
                                    <label class="text-sm text-gray-600 block mb-1">Uang Muka (DP)</label>
                                    <input type="number" x-model="dp" class="w-full border-gray-300 rounded p-2 focus:ring-blue-500 focus:border-blue-500" placeholder="Contoh: 50000000">
                                    <p class="text-xs text-gray-400 mt-1">Min. DP 20%</p>
                                </div>
                                
                                <div>
                                    <label class="text-sm text-gray-600 block mb-1">Tenor (Tahun)</label>
                                    <select x-model="tenor" class="w-full border-gray-300 rounded p-2 focus:ring-blue-500 focus:border-blue-500">
                                        <option value="1">1 Tahun</option>
                                        <option value="2">2 Tahun</option>
                                        <option value="3">3 Tahun</option>
                                        <option value="4">4 Tahun</option>
                                        <option value="5">5 Tahun</option>
                                    </select>
                                </div>

                                <button @click="calculate()" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 rounded transition" :disabled="loading">
                                    <span x-show="!loading">Hitung Cicilan</span>
                                    <span x-show="loading">Menghitung...</span>
                                </button>
                                
                                <div x-show="result" class="bg-blue-50 p-4 rounded-lg mt-4 border border-blue-100" style="display: none;">
                                    <div class="flex justify-between mb-2">
                                        <span class="text-sm text-gray-600">Cicilan / Bulan</span>
                                        <span class="font-bold text-blue-700" x-text="formatRupiah(result.cicilan)"></span>
                                    </div>
                                    <div class="flex justify-between mb-2">
                                        <span class="text-sm text-gray-600">Total DP</span>
                                        <span class="font-bold" x-text="formatRupiah(result.dp_murni)"></span>
                                    </div>
                                    <hr class="my-2 border-blue-200">
                                    <a :href="waLink" target="_blank" class="block text-center text-sm text-green-600 font-bold hover:underline">
                                        Ajukan Kredit Ini via WA &rarr;
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
             <!-- Related Cars -->
            @if($relatedCars->count() > 0)
            <div class="mt-16">
                <h3 class="text-xl font-bold mb-6">Mobil Sejenis Lainnya</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    @foreach($relatedCars as $related)
                    <div class="bg-white rounded-lg shadow hover:shadow-lg transition">
                         <div class="aspect-w-4 aspect-h-3">
                            <img src="{{ $related->images[0] ?? '' }}" class="object-cover rounded-t-lg">
                        </div>
                        <div class="p-4">
                            <h4 class="font-bold text-gray-900">{{ $related->name }}</h4>
                            <p class="text-blue-600 font-bold text-sm mt-1">Rp {{ number_format($related->price, 0) }}</p>
                             <a href="{{ route('cars.show', $related->slug) }}" class="block mt-3 text-center text-sm bg-gray-100 hover:bg-gray-200 text-gray-700 py-1 rounded">Lihat</a>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
            @endif
        </div>
    </div>

    <script>
        function creditCalculator() {
            return {
                price: {{ $car->price }},
                dp: {{ $car->dp_min ?? $car->price * 0.2 }}, // Default DP
                tenor: 5,
                bunga: 8, // Default interest rate 8%
                loading: false,
                result: null,
                waLink: '#',
                
                formatRupiah(number) {
                    return new Intl.NumberFormat('id-ID', { style: 'currency', currency: 'IDR', minimumFractionDigits: 0 }).format(number);
                },

                calculate() {
                    this.loading = true;
                    // Simulate API call or calculate locally
                    // For demo, we use the API endpoint we created
                    fetch('{{ route('api.credit.simulation') }}', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                        },
                        body: JSON.stringify({
                            price: this.price,
                            dp: this.dp,
                            tenor: this.tenor,
                            bunga: this.bunga
                        })
                    })
                    .then(response => response.json())
                    .then(data => {
                        this.result = data;
                        // Generate dynamic WA link
                        const text = `Halo, saya ingin simulasi kredit untuk ${this.formatRupiah(this.price)} (${'{{ $car->name }}'}). DP: ${this.formatRupiah(this.dp)}, Tenor: ${this.tenor} Tahun. Cicilan: ${this.formatRupiah(data.cicilan)}`;
                        this.waLink = `https://wa.me/6281234567890?text=${encodeURIComponent(text)}`;
                        this.loading = false;
                    })
                    .catch(error => {
                        console.error('Error:', error);
                        this.loading = false;
                    });
                }
            }
        }
    </script>
</x-app-layout>
