<?php

namespace Database\Seeders;

use App\Models\Brand;
use App\Models\Car;
use App\Models\Promotion;
use App\Models\Testimonial;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        // Seed Users
        \App\Models\User::create([
            'name' => 'Admin MobilSales',
            'email' => 'admin@mobilsales.com',
            'password' => bcrypt('password'), // password
            'role' => 'admin',
        ]);

        \App\Models\User::create([
            'name' => 'Sales Budi',
            'email' => 'budi@mobilsales.com',
            'password' => bcrypt('password'), // password
            'role' => 'sales',
        ]);

        // Seed Brands
        $toyota = Brand::create(['name' => 'Toyota', 'slug' => 'toyota', 'logo' => 'toyota.png']);
        $honda = Brand::create(['name' => 'Honda', 'slug' => 'honda', 'logo' => 'honda.png']);
        $mitsubishi = Brand::create(['name' => 'Mitsubishi', 'slug' => 'mitsubishi', 'logo' => 'mitsubishi.png']);

        // Seed Cars
        Car::create([
            'brand_id' => $toyota->id,
            'name' => 'Toyota Avanza Veloz',
            'slug' => 'toyota-avanza-veloz',
            'price' => 280000000,
            'dp_min' => 25000000,
            'specs' => ['mesin' => '1.5L Dual VVT-i', 'transmisi' => 'CVT', 'kursi' => '7 Seater'],
            'description' => 'MPV sejuta umat dengan fitur keselamatan TSS terbaru.',
            'status' => 'ready',
            'type' => 'MPV',
            'year' => 2024,
            'images' => ['https://imgcdnblog.carbay.com/wp-content/uploads/2021/11/10180424/2022-Toyota-Avanza-Veloz-Indonesia-launch-1.jpg'],
        ]);

        Car::create([
            'brand_id' => $honda->id,
            'name' => 'Honda Brio Satya',
            'slug' => 'honda-brio-satya',
            'price' => 180000000,
            'dp_min' => 15000000,
            'specs' => ['mesin' => '1.2L i-VTEC', 'transmisi' => 'CVT', 'kursi' => '5 Seater'],
            'description' => 'City car terlaris, irit bahan bakar dan lincah.',
            'status' => 'ready',
            'type' => 'City Car',
            'year' => 2024,
            'images' => ['https://asset.honda-indonesia.com/2023/05/05/exterior_3_1__1683281227845.jpg'],
        ]);

        Car::create([
            'brand_id' => $mitsubishi->id,
            'name' => 'Mitsubishi Xpander Cross',
            'slug' => 'mitsubishi-xpander-cross',
            'price' => 320000000,
            'dp_min' => 30000000,
            'specs' => ['mesin' => '1.5L MIVEC', 'transmisi' => 'CVT', 'kursi' => '7 Seater'],
            'description' => 'Crossover MPV tangguh dengan ground clearance tinggi.',
            'status' => 'indent',
            'type' => 'SUV',
            'year' => 2024,
            'images' => ['https://imgcdnblog.carbay.com/wp-content/uploads/2022/11/03165747/2023-Mitsubishi-Xpander-Cross-Philippines-launch.jpg'],
        ]);

        // Seed Promotions
        Promotion::create([
            'title' => 'Promo Akhir Tahun',
            'description' => 'Diskon hingga 20 Juta untuk pembelian Avanza',
            'valid_until' => now()->addDays(30),
            'type' => 'banner'
        ]);

        // Seed Testimonials
        Testimonial::create([
            'name' => 'Budi Santoso',
            'car_purchased' => 'Toyota Avanza',
            'content' => 'Pelayanan sangat ramah, proses kredit dibantu sampai ACC. Terima kasih MobilSales!',
            'type' => 'image',
            'photo' => 'https://randomuser.me/api/portraits/men/1.jpg'
        ]);
    }
}
