<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('cars', function (Blueprint $table) {
            $table->id();
            $table->foreignId('brand_id')->constrained()->onDelete('cascade');
            $table->string('name');
            $table->string('slug')->unique();
            $table->decimal('price', 15, 2);
            $table->decimal('dp_min', 15, 2)->nullable();
            $table->json('specs')->nullable(); // engine, fuel, transmission, seats, etc.
            $table->text('description')->nullable();
            $table->enum('status', ['ready', 'indent'])->default('ready');
            $table->json('images')->nullable();
            $table->string('video_url')->nullable();
            $table->string('type')->nullable(); // SUV, MPV, Sedan, etc.
            $table->integer('year')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('cars');
    }
};
