<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Car extends Model
{
    use HasFactory;

    protected $fillable = [
        'brand_id', 'name', 'slug', 'price', 'dp_min', 'specs',
        'description', 'status', 'images', 'video_url', 'type', 'year'
    ];

    protected $casts = [
        'specs' => 'array',
        'images' => 'array',
    ];

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function leads()
    {
        return $this->hasMany(Lead::class);
    }
}
