<?php

namespace App\Http\Controllers;

use App\Models\Brand;
use App\Models\Car;
use App\Models\Promotion;
use App\Models\Testimonial;
use Illuminate\Http\Request;

class PublicController extends Controller
{
    public function index()
    {
        $featuredCars = Car::where('status', 'ready')->latest()->take(6)->get();
        $promotions = Promotion::where('valid_until', '>=', now())->get();
        $testimonials = Testimonial::latest()->take(5)->get();
        $brands = Brand::all();

        return view('home', compact('featuredCars', 'promotions', 'testimonials', 'brands'));
    }

    public function catalog(Request $request)
    {
        $query = Car::query();

        if ($request->has('brand') && $request->brand != '') {
            $query->where('brand_id', $request->brand);
        }

        if ($request->has('price_min') && $request->price_min != '') {
            $query->where('price', '>=', $request->price_min);
        }

        if ($request->has('price_max') && $request->price_max != '') {
            $query->where('price', '<=', $request->price_max);
        }

        $cars = $query->paginate(12);
        $brands = Brand::all();

        return view('cars.index', compact('cars', 'brands'));
    }

    public function show(Car $car)
    {
        // Load related cars or same brand cars
        $relatedCars = Car::where('brand_id', $car->brand_id)
            ->where('id', '!=', $car->id)
            ->take(4)
            ->get();

        return view('cars.show', compact('car', 'relatedCars'));
    }

    public function tradeIn()
    {
        $cars = Car::where('status', 'ready')->get();
        return view('trade_in', compact('cars'));
    }

    public function testDrive()
    {
        $cars = Car::where('status', 'ready')->get();
        return view('test_drive', compact('cars'));
    }

    public function simulateCredit(Request $request)
    {
        $request->validate([
            'price' => 'required|numeric',
            'dp' => 'required|numeric',
            'tenor' => 'required|integer|min:1|max:8', // years
            'bunga' => 'required|numeric', // percentage per year
        ]);

        $price = $request->price;
        $dp = $request->dp;
        $tenor = $request->tenor; // in years
        $bungapy = $request->bunga / 100;

        $loanAmount = $price - $dp;
        $totalBunga = $loanAmount * $bungapy * $tenor;
        $totalLoan = $loanAmount + $totalBunga;
        
        $cicilanPerBulan = $totalLoan / ($tenor * 12);

        return response()->json([
            'cicilan' => round($cicilanPerBulan),
            'total_bunga' => round($totalBunga),
            'total_pembayaran' => round($totalLoan + $dp),
            'dp_murni' => $dp,
            'wa_link' => (new \App\Services\WhatsAppService())->generateLink(
                '6281234567890', 
                (new \App\Services\WhatsAppService())->generateCreditSimulationMessage(
                    'Simulasi Kredit', // In a real app, you'd pass the car name
                    $price, 
                    $dp, 
                    $tenor, 
                    round($cicilanPerBulan)
                )
            )
        ]);
    }
}
