<?php

namespace App\Http\Controllers;

use App\Models\Car;
use App\Models\Lead;
use App\Models\User;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    public function dashboard()
    {
        $stats = [
            'total_cars' => Car::count(),
            'total_leads' => Lead::count(),
            'new_leads' => Lead::where('status', 'new')->count(),
            'sales_team' => User::where('role', 'sales')->count(),
        ];

        $recentLeads = Lead::with('car')->latest()->take(5)->get();
        $popularCars = Car::withCount('leads')->orderBy('leads_count', 'desc')->take(5)->get();

        return view('admin.dashboard', compact('stats', 'recentLeads', 'popularCars'));
    }
}
