<?php

namespace App\Http\Controllers;

use App\Models\Brand;
use App\Models\Car;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class AdminCarController extends Controller
{
    public function index()
    {
        $cars = Car::with('brand')->latest()->paginate(10);
        return view('admin.cars.index', compact('cars'));
    }

    public function create()
    {
        $brands = Brand::all();
        return view('admin.cars.create', compact('brands'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'brand_id' => 'required',
            'price' => 'required|numeric',
            'description' => 'required',
            'year' => 'required|numeric',
            'image_url' => 'required|url', // Simplification: using URL input for now
        ]);

        Car::create([
            'name' => $request->name,
            'slug' => Str::slug($request->name) . '-' . Str::random(5),
            'brand_id' => $request->brand_id,
            'price' => $request->price,
            'dp_min' => $request->price * 0.2, // Auto calculate default DP
            'description' => $request->description,
            'year' => $request->year,
            'status' => 'ready',
            'images' => [$request->image_url], // Store as array
            'type' => 'SUV' // Default for now
        ]);

        return redirect()->route('admin.cars.index')->with('success', 'Mobil berhasil ditambahkan');
    }

    public function edit(Car $car)
    {
        $brands = Brand::all();
        return view('admin.cars.edit', compact('car', 'brands'));
    }

    public function update(Request $request, Car $car)
    {
        $request->validate([
            'name' => 'required',
            'brand_id' => 'required',
            'price' => 'required|numeric',
            'description' => 'required',
            'year' => 'required|numeric',
            'image_url' => 'required|url',
        ]);

        $car->update([
            'name' => $request->name,
            'brand_id' => $request->brand_id,
            'price' => $request->price,
            'description' => $request->description,
            'year' => $request->year,
            'images' => [$request->image_url],
        ]);

        return redirect()->route('admin.cars.index')->with('success', 'Mobil berhasil diupdate');
    }

    public function destroy(Car $car)
    {
        $car->delete();
        return redirect()->route('admin.cars.index')->with('success', 'Mobil berhasil dihapus');
    }
}
